<?php
/**
 * @package Blox Monochrome
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('post blox grid-100'); ?>>
	<span class="postheading">
		<h3 class="left"><?php the_title(); ?></h3>
		<?php edit_post_link( __( 'Edit', 'blox' ), '<span class="edit-link thin left">- ', '</span>' ); ?>
		<h5 class="right thin"><?php blox_posted_on(); ?></h5>
	</span>
	<span class="postheading">
		<h5 class="left thin">By <?php blox_posted_by() ?></h5>
		<h5 class="right thin">
			<?php
				$categories_list = get_the_category_list( '|' );

				if ( blox_categorized_blog() ){
					$categories_exploded = explode('|', $categories_list);
					foreach ($categories_exploded as $key => $value) {
						printf( __( '%1$s', 'blox' ), $value );
					}
				}
			?>
		</h5>
	</span>

	<div class="entry-content postcontents light">
		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'blox' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<div class="tags">
		<ul>
			<li><h5 class="light">Tags:</h5></li>
			
			<?php
				echo get_the_tag_list('<li>','</li><li>','</li>');
			?>
			<a href="<?php get_permalink() ?>" class="button permalink right">Permalink</a>
		</ul>
	</div>
</article><!-- #post-## -->

<div class="about blox grid-100">
	<span class="header clearfix">
		<h4 class="left">About Author:</h4>
		<h5 class="left" style="line-height: 22px;"><?php echo the_author_posts_link() ?></h5>

		<?php if( get_the_author_meta('linkedin_profile') != '' ):?>
			<h5 class="right light"><a href="<?php echo esc_url(get_the_author_meta('linkedin_profile')); ?>" target="_blank">LinkedIn</a></h5>
		<?php endif; ?>

		<?php if( get_the_author_meta('twitter_profile') != '' ):?>
			<h5 class="right light"><a href="<?php echo esc_url(get_the_author_meta('twitter_profile')); ?>" target="_blank">Twitter</a></h5>
		<?php endif; ?>

		<?php if( get_the_author_meta('facebook_profile') != '' ):?>
			<h5 class="right light"><a href="<?php echo esc_url(get_the_author_meta('facebook_profile')); ?>" target="_blank">Facebook</a></h5>
		<?php endif; ?>

		<?php if( get_the_author_meta('google_profile') != '' ):?>
			<h5 class="right light"><a href="<?php echo esc_url(get_the_author_meta('google_profile')); ?>" target="_blank">Google+</a></h5>
		<?php endif; ?>

		<?php if( get_the_author_meta('user_url') != '' ):?>
			<h5 class="right light"><a href="<?php echo esc_url(get_the_author_meta('user_url')); ?>" target="_blank">Website</a></h5>
		<?php endif; ?>

	</span>
	<div class="left"><?php echo get_avatar( get_the_author_meta('email') , 85 ); ?></div>
	<div class="description light">
		<?php echo get_the_author_meta('description') ?>
	</div>
</div>